<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('user.list_title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="<?php echo e(route('user.index')); ?>">
										<?php echo e(csrf_field()); ?>

										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control" placeholder="Search"
												required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit">
													<i class="fas fa-search"></i>
												</button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th><?php echo e(__('user.th_user')); ?></th>
													<th><?php echo e(__('user.th_name')); ?></th>
													<th><?php echo e(__('user.th_email')); ?></th>
													<th><?php echo e(__('user.th_role')); ?></th>
													<th><?php echo e(__('user.th_status')); ?></th>
													<th class="nowrap"><?php echo e(__('user.th_created_at')); ?></th>
													<th class="fixed-width-td"><?php echo e(__('user.th_action')); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td class="align-middle">
														<div class="img-circle elevation-2 profile-image"
															style="background-image: url(' <?php echo e(img_url($user->profile_picture)); ?> ');">
														</div>
													</td>
													<td class="align-middle nowrap">
														<?php echo e($user->name); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($user->email); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(user_role($user->roles->first())); ?>

													</td>
													<td class="align-middle">
														<?php echo status_badge($user->status); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(format_date($user->created_at)); ?>

													</td>
													<td>
														<div class="d-flex">
															<a href="<?php echo e(route('user.edit', $user->id)); ?>" type="button"
																class="btn btn-warning mr-2">
																<i class="fa fa-edit"></i>
															</a>
															<form class="d-inline js-confirm-delete" method="POST"
																action="<?php echo e(route('user.destroy', $user->id)); ?>">
																<?php echo e(csrf_field()); ?>

																<?php echo method_field('DELETE'); ?>
																<button class="btn btn-danger">
																	<i class="fa fa-trash"></i>
																</button>
															</form>
														</div>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php if(count($users) == 0): ?>
												<tr>
													<td colspan="9">
														<p class="text-center mb-0"><?php echo e(__('user.no_record_found')); ?></p>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										<?php if($paginate): ?>
										<?php echo e($users->links()); ?>

										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/user/list.blade.php ENDPATH**/ ?>